package com.example.tp5_06;

import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;

public class MainActivity extends AppCompatActivity {
    private static final String TAG = "MainActivity";
    TextView textView;
    int i = 0;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        Log.i(TAG, "onCreate: Thead ID: " + Thread.currentThread().getId());
        textView = (TextView) findViewById(R.id.textview);

        Button button = (Button) findViewById(R.id.button);
        button.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Toast.makeText(MainActivity.this, "Inner Thread", Toast.LENGTH_SHORT).show();
                new Thread() {
                    public void run() {
                        while (i++ < 100) {
                            Log.i(TAG, "Thread:run: Thead ID: " + Thread.currentThread().getId());
                            try {
                                textView.post(new Runnable() {
                                    @Override
                                    public void run() {
                                        Log.i(TAG, "textView.post:run: Thead ID: " + Thread.currentThread().getId());
                                        textView.setText("#" + i);
                                    }
                                });
                                Thread.sleep(300);
                            } catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }.start();
            }
        });
        Button button2 = (Button) findViewById(R.id.button2);
        button2.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Toast.makeText(MainActivity.this, "Thread Subclass (WorkerThread)", Toast.LENGTH_SHORT).show();
                WorkerThread worker = new WorkerThread(textView);
                worker.start();
            }
        });
    }
}
